% demo_video_parallel_cs.m
%
% Demo to show the performance of proposed video compression scheme.
%
% Written: Hao Fang
% Created: Mar. 2012
% Modified: Apr. 2013

%=======================================
clear all;
close all;
clc;

path(path, '../Videos');
path(path, './Measurements');
path(path, '../Tools');
path(path, '../Tools/YUV');
path(path, '../Tools/ZIGZAG_PERM');
path(path, '../Tools/ZIGZAG_SCAN');

% akiyo_qcif
% carphone_qcif
% claire_qcif
% coastguard_qcif
% foreman_qcif
% salesman_qcif
filename = 'coastguard_qcif';
yuvformat = 'qcif';

scheme = 1;
%======================================
% comment above lines when run script_demo_video_parallel_cs_x.m

switch yuvformat
    case 'cif'
        dims = [352 288];
    case 'qcif'
        dims = [176 144];
end
numfrm = 10;
startfrm = 0;
[Y, U, V] = yuv_import(sprintf('%s.yuv', filename), dims, numfrm, startfrm, yuvformat);
GOP = 2;

% load random states for repeatable experiments
load RandomStates
rand('state', rand_state);
randn('state', randn_state);

CR = 0.1:0.1:0.5;

N = dims(2);
Ave_PSNR = zeros(1, length(CR));
Ave_PSNR_Ref = zeros(1, length(CR));
Ave_PSNR_Non_Ref = zeros(1, length(CR));
Rec_Y = cell(length(CR), numfrm);
for mm = 1:length(CR)
    K = ceil(GOP*N*CR(mm));
    A = sqrt(1/K) * randn(K, N);

    Frames = cell(1, GOP);
    PSNR = zeros(1, numfrm);
    SSIM = zeros(1, numfrm);
    for ii = 1:GOP:numfrm
        for jj = 1:GOP
            Frames{jj} = double(Y{ii+jj-1});
        end
        Rec_Frames = parallel_cs(Frames, A, scheme);
        for jj = 1:GOP
            Rec_Y{mm,ii+jj-1} = Rec_Frames{jj};
            PSNR(ii+jj-1) = psnr(double(Frames{jj}), double(Rec_Frames{jj}));
        end
    end
    Ave_PSNR(mm) = mean(PSNR);
    Ave_PSNR_Ref(mm) = mean(PSNR(1:GOP:numfrm));
    Ave_PSNR_Non_Ref(mm) = mean(PSNR(setdiff(1:numfrm, 1:GOP:numfrm)));
end

if (scheme == 0) 
    save(sprintf('./Data/%s_noperm.mat', filename),...
        'Ave_PSNR_Ref',...
        'Ave_PSNR_Non_Ref',...
        'CR',...
        'filename');   
end
if (scheme == 1) 
    save(sprintf('./Data/%s_zigzagperm.mat', filename),...
        'Ave_PSNR_Ref',...
        'Ave_PSNR_Non_Ref',...
        'CR',...
        'filename');   
end
